@extends('layouts.app')

@section('title', $user->name . ' - Profile')

@section('content')
<div class="profile-container">
    <!-- Profile Banner -->
    <div class="profile-banner">
        @if($user->banner)
            <img src="{{ Storage::url('user_banners/' . $user->banner) }}" alt="{{ $user->name }}'s Banner" class="banner-image">
        @else
            <div class="default-banner-bg"></div>
        @endif
    </div>
    
    <div class="profile-header">
        <div class="profile-avatar">
            <img src="{{ $user->avatar }}" alt="{{ $user->name }}'s Avatar">
        </div>
        <div class="profile-info">
            <h1 class="profile-name">{{ $user->name }}</h1>
            
            <div class="profile-steam">
                <a href="{{ $user->getSteamProfileUrl() }}" target="_blank" class="steam-link">
                    <i class="fab fa-steam"></i> Steam Profile
                </a>
            </div>
            
            @if(Auth::id() === $user->id)
                <div class="profile-actions">
                    <a href="{{ route('profile.edit') }}" class="btn btn-primary">
                        <i class="fas fa-edit"></i> Edit Profile
                    </a>
                </div>
            @endif
        </div>
    </div>
    
    <!-- Stats Overview -->
    <div class="stats-row">
        <div class="stat-card">
            <div class="stat-icon">
                <i class="fas fa-calendar-alt"></i>
            </div>
            <div class="stat-value">{{ $user->created_at->format('Y') }}</div>
            <div class="stat-label">Member Since</div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon">
                <i class="fas fa-comment-alt"></i>
            </div>
            <div class="stat-value">{{ $activities->count() }}</div>
            <div class="stat-label">Activities</div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon">
                <i class="fas fa-trophy"></i>
            </div>
            <div class="stat-value">{{ $achievements->count() }}</div>
            <div class="stat-label">Achievements</div>
        </div>
    </div>
    
    <div class="profile-content">
        <!-- User Info Section -->
        <div class="profile-section">
            <h2 class="section-title">
                <i class="fas fa-user-circle"></i> User Info
            </h2>
            <div class="info-card">
                <div class="info-item">
                    <span class="info-label">Member since:</span>
                    <span class="info-value">{{ $user->created_at->format('F j, Y') }}</span>
                </div>
                <div class="info-item">
                    <span class="info-label">Steam ID:</span>
                    <span class="info-value">{{ $user->steamid }}</span>
                </div>
                
                @if($user->roles && $user->roles->count() > 0)
                    <div class="info-item">
                        <span class="info-label">Roles:</span>
                        <div class="role-badges">
                            @foreach($user->roles as $role)
                                <span class="role-badge">{{ $role->name }}</span>
                            @endforeach
                        </div>
                    </div>
                @endif
            </div>
        </div>
        
        <!-- Achievements Section -->
        <div class="profile-section achievements-section">
            <h2 class="section-title">
                <i class="fas fa-trophy"></i> Achievements
            </h2>
            <div class="info-card">
                @if($achievements && $achievements->count() > 0)
                    <div class="all-achievements">
                        <h3 class="sub-section-title">All Achievements</h3>
                        <div class="achievements-grid">
                            @foreach($achievements as $achievement)
                                @if($achievement->unlocked_at)
                                    <div class="achievement-card">
                                        <div class="achievement-icon">
                                            <i class="fas {{ $achievement->icon ?? 'fa-trophy' }}"></i>
                                        </div>
                                        <div class="achievement-info">
                                            <div class="achievement-name">{{ $achievement->name }}</div>
                                            <div class="achievement-description">{{ $achievement->description }}</div>
                                            <div class="achievement-unlocked">
                                                Unlocked {{ $achievement->unlocked_at->diffForHumans() }}
                                            </div>
                                        </div>
                                    </div>
                                @endif
                            @endforeach
                        </div>
                    </div>
                @else
                    <div class="empty-achievements">
                        <div class="empty-icon">
                            <i class="fas fa-trophy"></i>
                        </div>
                        <h3 class="empty-title">No Achievements Yet</h3>
                        <p class="empty-description">
                            This user hasn't unlocked any achievements yet. Check back later!
                        </p>
                    </div>
                @endif
            </div>
        </div>
    </div>
    
    @if(config_value('forum_allow_activities', true))
    <!-- Activity Section -->
    <div class="profile-section activity-section-small">
        <div class="activity-header">
            <h2 class="section-title">
                <i class="fas fa-history"></i> Recent Activity
            </h2>
        </div>
        
        <div class="info-card">
            @if($activities->count() > 0)
                <div class="activity-timeline-small">
                    @foreach($activities->take(3) as $activity)
                        @php
                            $activityData = json_decode($activity->activity_data);
                            $activityType = strtolower($activity->activity_type);
                            
                            // Determine icon based on activity type
                            $icon = 'fa-circle';
                            
                            if (strpos($activityType, 'replied') !== false) {
                                $icon = 'fa-reply';
                            } elseif (strpos($activityType, 'created thread') !== false) {
                                $icon = 'fa-plus-circle';
                            } elseif (strpos($activityType, 'joined server') !== false) {
                                $icon = 'fa-server';
                            } elseif (strpos($activityType, 'purchased') !== false) {
                                $icon = 'fa-shopping-cart';
                            } elseif (strpos($activityType, 'achievement') !== false) {
                                $icon = 'fa-trophy';
                            }
                            
                            // Determine content details
                            $detailText = '';
                            $linkUrl = '#';
                            $linkText = '';
                            
                            if (isset($activityData->thread_name)) {
                                $detailText = $activityData->thread_name;
                                if (isset($activityData->board_name)) {
                                    $detailText .= ' in ' . $activityData->board_name;
                                }
                                $linkText = 'View Thread';
                                $linkUrl = isset($activityData->thread_slug) ? 
                                    route('forum.thread', $activityData->thread_slug) : '#';
                            } elseif (isset($activityData->server_name)) {
                                $detailText = $activityData->server_name;
                                $linkText = '';
                                $linkUrl = '#';
                            } elseif (isset($activityData->item_name)) {
                                $detailText = $activityData->item_name;
                                $linkText = 'View Item';
                                $linkUrl = isset($activityData->item_id) ? 
                                    route('store.show', $activityData->item_id) : '#';
                            } elseif (isset($activityData->achievement_name)) {
                                $detailText = $activityData->achievement_name;
                                $linkText = '';
                                $linkUrl = '#';
                            }
                        @endphp
                        
                        <div class="activity-item">
                            <div class="activity-dot"></div>
                            <div class="activity-card">
                                <div class="activity-header">
                                    <span class="activity-type">
                                        <i class="fas {{ $icon }}"></i>
                                        {{ ucfirst(explode(' ', $activityType)[0]) }}
                                    </span>
                                    <span class="activity-time">{{ $activity->created_at->diffForHumans() }}</span>
                                </div>
                                
                                <div class="activity-content">
                                    <div class="activity-title">
                                        {{ $user->name }} {{ $activity->activity_type }}
                                    </div>
                                    <div class="activity-details">
                                        {{ $detailText ?: 'Activity details not available.' }}
                                    </div>
                                </div>
                                
                                @if($linkText)
                                <!-- Maybe... I don't like it? I Think?
                                <div class="activity-footer">
                                    <a href="{{ $linkUrl }}" class="activity-link">
                                        {{ $linkText }} <i class="fas fa-arrow-right"></i>
                                    </a>
                                </div>
                                -->
                                @endif
                            </div>
                        </div>
                    @endforeach
                </div>
                
                @if($activities->hasPages())
                    <div class="pagination-container">
                        {{ $activities->links() }}
                    </div>
                @endif
            @else
                <div class="empty-activity">
                    <div class="empty-icon">
                        <i class="fas fa-calendar-day"></i>
                    </div>
                    <h3 class="empty-title">No Activity Yet</h3>
                    <p class="empty-description">
                        This user hasn't recorded any activity yet. Check back later!
                    </p>
                </div>
            @endif
        </div>
    </div>
    @endif
</div>
@endsection